/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.items.metal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.api.capability.heat.ItemHeatHandler;
import net.dries007.tfc.api.capability.metal.IMetalItem;
import net.dries007.tfc.api.capability.size.Size;
import net.dries007.tfc.api.capability.size.Weight;
import net.dries007.tfc.api.types.Metal;
import net.dries007.tfc.api.types.Ore;
import net.dries007.tfc.objects.items.ItemTFC;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemOreTFC
extends ItemTFC
implements IMetalItem {
    private static final Map<Ore, ItemOreTFC> MAP = new HashMap<Ore, ItemOreTFC>();
    public final Ore ore;

    public static ItemOreTFC get(Ore ore) {
        return MAP.get((Object)ore);
    }

    public static ItemStack get(Ore ore, Ore.Grade grade, int amount) {
        return new ItemStack((Item)MAP.get((Object)ore), amount, ore.isGraded() ? grade.getMeta() : 0);
    }

    public static ItemStack get(Ore ore, int amount) {
        return new ItemStack((Item)MAP.get((Object)ore), amount);
    }

    public ItemOreTFC(Ore ore) {
        this.ore = ore;
        if (MAP.put(ore, this) != null) {
            throw new IllegalStateException("There can only be one.");
        }
        this.func_77656_e(0);
        if (ore.getMetal() != null) {
            this.func_77627_a(true);
            for (Ore.Grade grade : Ore.Grade.values()) {
                String name = ore.getMetal().getRegistryName().func_110623_a();
                OreDictionaryHelper.registerMeta(this, grade.getMeta(), new Object[]{"ore", name, grade});
                OreDictionaryHelper.registerMeta(this, grade.getMeta(), new Object[]{"ore", grade, name});
                if (ore.getMetal() != Metal.WROUGHT_IRON || !ConfigTFC.General.MISC.dictionaryIron) continue;
                OreDictionaryHelper.registerMeta(this, grade.getMeta(), new Object[]{"ore", "iron", grade});
                OreDictionaryHelper.registerMeta(this, grade.getMeta(), new Object[]{"ore", grade, "iron"});
            }
        } else {
            String oreName;
            switch (oreName = ore.getRegistryName().func_110623_a()) {
                case "lapis_lazuli": {
                    OreDictionaryHelper.register(this, "gem", "lapis");
                    break;
                }
                case "bituminous_coal": {
                    OreDictionaryHelper.register(this, "gem", "coal");
                    break;
                }
                case "lignite": {
                    OreDictionaryHelper.register(this, "gem", "lignite");
                    break;
                }
                default: {
                    OreDictionaryHelper.register(this, new Object[]{"gem", ore});
                }
            }
        }
    }

    @Nonnull
    public Ore.Grade getGradeFromStack(ItemStack stack) {
        return Ore.Grade.valueOf(stack.func_77952_i());
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        Ore.Grade grade = this.getGradeFromStack(stack);
        if (grade == Ore.Grade.NORMAL) {
            return super.func_77667_c(stack);
        }
        return super.func_77667_c(stack) + "." + grade.func_176610_l();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        Metal metal = this.getMetal(stack);
        if (metal != null) {
            int smeltAmount = this.getSmeltAmount(stack);
            int meltTemp = (int)this.getMeltTemp(stack);
            switch (ConfigTFC.Client.TOOLTIP.oreTooltipMode) {
                case HIDE: {
                    break;
                }
                case UNIT_ONLY: {
                    String info = String.format("%s: %s", I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]), I18n.func_135052_a((String)"tfc.tooltip.units", (Object[])new Object[]{smeltAmount}));
                    tooltip.add(info);
                    break;
                }
                case TOTAL_ONLY: {
                    String stackTotal = String.format("%s: %s", I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]), I18n.func_135052_a((String)"tfc.tooltip.units.total", (Object[])new Object[]{smeltAmount * stack.func_190916_E()}));
                    tooltip.add(stackTotal);
                    break;
                }
                case ALL_INFO: {
                    String infoTotal = stack.func_190916_E() > 1 ? String.format("%s: %s", I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]), I18n.func_135052_a((String)"tfc.tooltip.units.info_total", (Object[])new Object[]{smeltAmount, smeltAmount * stack.func_190916_E()})) : String.format("%s: %s", I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]), I18n.func_135052_a((String)"tfc.tooltip.units", (Object[])new Object[]{smeltAmount}), I18n.func_135052_a((String)"tfc.tooltip.melttemp", (Object[])new Object[]{meltTemp}));
                    tooltip.add(infoTotal);
                    break;
                }
                case ADVANCED: {
                    String advancedTotal = stack.func_190916_E() > 1 ? String.format("%s: %s: %s", I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]), I18n.func_135052_a((String)"tfc.tooltip.units.info_total", (Object[])new Object[]{smeltAmount, smeltAmount * stack.func_190916_E()}), I18n.func_135052_a((String)"tfc.tooltip.melttemp", (Object[])new Object[]{meltTemp})) : String.format("%s: %s: %s", I18n.func_135052_a((String)Helpers.getTypeName(metal), (Object[])new Object[0]), I18n.func_135052_a((String)"tfc.tooltip.units", (Object[])new Object[]{smeltAmount}), I18n.func_135052_a((String)"tfc.tooltip.melttemp", (Object[])new Object[]{meltTemp}));
                    tooltip.add(advancedTotal);
                }
            }
        }
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            if (this.ore.isGraded()) {
                for (Ore.Grade grade : Ore.Grade.values()) {
                    items.add((Object)new ItemStack((Item)this, 1, grade.getMeta()));
                }
            } else {
                items.add((Object)new ItemStack((Item)this));
            }
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        return this.ore.getMetal() != null ? new ItemHeatHandler(nbt, this.ore.getMetal().getSpecificHeat(), this.ore.getMetal().getMeltTemp()) : null;
    }

    @Override
    @Nullable
    public Metal getMetal(ItemStack stack) {
        return this.ore.getMetal();
    }

    @Override
    public int getSmeltAmount(ItemStack stack) {
        return this.getGradeFromStack(stack).getSmeltAmount();
    }

    @Override
    public boolean canMelt(ItemStack stack) {
        return this.ore.canMelt();
    }

    @Override
    public float getMeltTemp(ItemStack stack) {
        if (this.canMelt(stack)) {
            return this.ore.getMetal().getMeltTemp();
        }
        return 0.0f;
    }

    @Override
    @Nonnull
    public Size getSize(@Nonnull ItemStack stack) {
        return Size.SMALL;
    }

    @Override
    @Nonnull
    public Weight getWeight(@Nonnull ItemStack stack) {
        return Weight.MEDIUM;
    }
}

